/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
/// ' Microsoft Content Management Server - Sample Code 
/// '
/// ' This sample code is provided "AS IS" with no warranties, and confers no rights. 
/// ' You assume all risk for your use.  2002 Microsoft Corporation. All rights reserved.
/// '
/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	
using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Web.UI.HtmlControls;
using System.Drawing;
//Array reference for array of breadcrumbs
using System.Collections;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
//Add reference to the CMS API
using Microsoft.ContentManagement.Publishing;

namespace McmsSpsWebControlLibrary
{
	/// <summary>	
	/// 
	/// 
	///		Summary description for McmsBreadcrumbControl.
	///		This class implements a 'breadcrumb' navigation trail. 
	/// </summary>
	[Designer(typeof(McmsSpsWebControlLibrary.Design.McmsBreadcrumbDesigner)),
	ToolboxBitmapAttribute(typeof(McmsBreadcrumbControl), "MCMSToolBoxImage.bmp"),
	ToolboxData("<{0}:McmsBreadcrumbControl runat=server></{0}:McmsBreadcrumbControl>")]
	public class McmsBreadcrumbControl : System.Web.UI.WebControls.WebControl,INamingContainer
	{
		#region Public constructors
		public McmsBreadcrumbControl(): base()
		{
			//Assign default values to properties 
			designText = "Mcms > Breadcrumb > Control";
			cssClass = "breadcrumb";
			topChannel = "/Channels";
			separator = "&nbsp;&nbsp;&gt;&nbsp;&nbsp;&nbsp;";
		
			string SeparatorString = " :: ";
			// Write a line to the Listener
			System.Diagnostics.Trace.WriteLine(System.DateTime.Now + SeparatorString + "Control" + SeparatorString + "Breadcrumb Control" + SeparatorString + "This is the constructor for the Breadcrumb Control.");
			// Record your output
			System.Diagnostics.Trace.Flush();
		}
		#endregion Public constructors

		#region Private member declarations

		private string text;
		//User defined properties 
		private string designText;
		private string cssClass;
		private string topChannel;
		private string startChannel;
		private string separator;

		//Select list for channel name format
		public enum enumChannelNameOptions{Name, DisplayName};
		private enumChannelNameOptions enumChannelName;
		#endregion Private member declarations

		#region Properties

		/// <summary>
		///		Default text property.
		/// </summary>
		/// 
		[Bindable(true), 
			Category("Appearance"), 
			DefaultValue("")] 
		public string Text 
		{
			get
			{
				return text;
			}

			set
			{
				text = value;
			}
		}

		/// <summary>
		///		The text that appears in the control in design view.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Text that appears in design view."),
		Category("Breadcrumb")]
		public string DesignText
		{
			get { return designText; }
			set { designText = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeDesignText(){return true;}
			
		/// <summary>
		///		The CSS style class for the control - both runtime and design.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("CSS Style for the breadcrumb control."),
		Category("Appearance")]
		public override string CssClass
		{
			get { return cssClass; }
			set { cssClass = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeCssClass(){return true;}
	
		/// <summary>
		///		The path used to determne the upper limit of the breadcrumb trail.
		/// </summary>
		/// 		
		//Default top channel path is the root channel
		[Description("The top limit to the breadcrumb trail. Defined by the path to the top Channel."),
		Category("Breadcrumb"),]
		public string TopChannel
		{
			get { return topChannel; }
			set { topChannel = value; }
		}	
		//Allow user to change the value of property - in design view
		bool ShouldSerializeTopChannel(){return true;}

		/// <summary>
		///		The path used to determine the start of the breadcrumb trail.
		/// </summary>
		/// 		
		//Default start channel path is the current channel
		[Description("The start Shannel of the breadcrumb trail. Defined by the path to the start Channel."),
		Category("Breadcrumb"),]
		public string StartChannel
		{
			get { return startChannel; }
			set { startChannel = value; }
		}	
		//Allow user to change the value of property - in design view
		bool ShouldSerializeStartChannel(){return true;}

		/// <summary>
		///		The Channel name used in the breadcrumb.
		///		Options: DisplayName, Name
		/// </summary>
		/// 		
		[Description("The Channel name type used in the breadcrumb. Options are 'DisplayName' and 'Name'."),
		Category("Breadcrumb"),]
		public enumChannelNameOptions ChannelName
		{
			get { return enumChannelName; }
			set { enumChannelName = value; }
		}			
		//Allow user to change the value of property - in design view
		bool ShouldSerializeChannelName(){return true;}

		/// <summary>
		///		The HTML between the Channels in the breadcrumb.
		/// </summary>
		/// 		
		[Description("The separator HTML used in the breadcrumb."),
		Category("Breadcrumb"),]
		public string Separator
		{
			get { return separator; }
			set { separator = value; }
		}	
		//Allow user to change the value of property - in design view
		bool ShouldSerializeSeparator(){return true;}

		#endregion Properties

		#region Private functions
		/// <summary>
		///		Create table controls for breadcrumb list.
		/// </summary>
		protected override void CreateChildControls()
		{
			//Call base class
			base.CreateChildControls();
			// Code to create a Table
			System.Web.UI.WebControls.Table	tblBread = new System.Web.UI.WebControls.Table();
			//Populate Breadcrumb table
			PopulateBreadTable(tblBread);
			// Add table to the Controls collection so it gets rendered
			Controls.Add(tblBread);

		} //Close child controls
		
		/// <summary>
		/// Function to create array of channel objects for the breadcrumb trail.
		/// </summary>
		private ArrayList BreadStepArray(Channel chChannel, ArrayList arBreadcrumbArray)
		{
			//Instantiate CMS HTML Context
			CmsHttpContext CMSContext = CmsHttpContext.Current;

			Channel chTop;
			//Get the top channel limit from the TopChannel property
			if(TopChannel != null)
			{
				chTop = (Channel)CMSContext.Searches.GetByPath(TopChannel);
			}
			else 
			{
				chTop = CMSContext.RootChannel;
			}
			
			//Error check for null Channel object
			if(chTop == null)
			{
				return arBreadcrumbArray; //Early return
			}

			Channel objTopChannel; 

			//Ensure that the top channel is a parent of the current channel
			if(CMSContext.Posting.IsDescendantOf(chTop))
			{
				objTopChannel = chTop;
			}
			else //Current channel is not a descendant of the top channel
			{
				//Use the rootchannel as the default
				objTopChannel = CMSContext.RootChannel;
			}

			//Error check for invalid Channel path - use root as default
			if(objTopChannel == null)
			{	
				objTopChannel = CMSContext.RootChannel;
			}

			//Do not traverse higher than the TopChannel property of the control			
			if(chChannel == objTopChannel)
			{
				arBreadcrumbArray.Add(chChannel);
				return arBreadcrumbArray;
			}
			else
			{
				arBreadcrumbArray.Add(chChannel);
				return BreadStepArray(chChannel.Parent, arBreadcrumbArray);
			}
		} //Close BreadStepArray

		/// <summary>
		/// Function to populate the table control used to present data.
		/// </summary>
		private Table PopulateBreadTable(Table tblBread)
		{
			//Instantiate CMS HTML Context
			CmsHttpContext CMSContext = CmsHttpContext.Current;		
			
			//Use the user defined style sheet class
			tblBread.CssClass = CssClass;

			System.Web.UI.WebControls.TableRow	row;
			System.Web.UI.WebControls.TableCell	cell;
			row = new System.Web.UI.WebControls.TableRow();
			tblBread.Rows.Add(row);			
			
			//Create an anchor object
			HtmlAnchor navLink;
			
			//Set user defined channel to start the breadcrumb
			Channel objNavChannel;
			if(StartChannel != null)
			{
				objNavChannel = (Channel)CMSContext.Searches.GetByPath(StartChannel);
			}
			else
			{
				objNavChannel = CMSContext.Channel;
			}

			//Error check for null channel object
			if(objNavChannel.Equals(null))
			{
				return tblBread; //Early return
			}
			
			//Create the array for channel objects in the trail
			ArrayList arBreadcrumb = new ArrayList();
			//Call function to create array of breadcrumb channels
			ArrayList arBreadcrumbs = BreadStepArray(objNavChannel, arBreadcrumb);
			//Reverse the array so that the channels are in the right order
			arBreadcrumbs.Reverse();

			if(arBreadcrumbs.Count>0)
			{
				//Loop through array and create row of links to channels
				foreach(Channel objBreadChannel in arBreadcrumbs)
				{
					// Prepare Channel anchor link
					navLink = new HtmlAnchor();

					//Add user defined option for Channel name (DisplayName or Name)
					if(ChannelName.ToString() == "Name")
					{ 
						navLink.InnerHtml = HttpUtility.HtmlEncode(objBreadChannel.Name);
					}
					else
					{ 
						navLink.InnerHtml = HttpUtility.HtmlEncode(objBreadChannel.DisplayName);
					}

					//Add URL to Channel - use flexible URL instead of mode specific
					navLink.HRef = objBreadChannel.Url;
					cell = new System.Web.UI.WebControls.TableCell();
					cell.Controls.Add(navLink);
					cell.Wrap = false;
					row.Cells.Add(cell);

					// Add spacer cell between links
					cell = new System.Web.UI.WebControls.TableCell();
					cell.Text += Separator;
					cell.Wrap = false;
					row.Cells.Add(cell);
				}		
			}
			// Add current posting after breadcrumb links
			cell = new System.Web.UI.WebControls.TableCell();
			cell.Text += HttpUtility.HtmlEncode(CMSContext.Posting.DisplayName);
			cell.Wrap = false;
			row.Cells.Add(cell);

			return tblBread;

		} //Close PopulateBreadTable

		#endregion Private functions

	} //Close class
}  //Close library

//EOF - SC - Jan 2002